/*
 * Decompiled with CFR 0.152.
 */
package qz;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import qz.ByteArrayBuilder;
import qz.ByteUtilities;
import qz.FileUtilities;
import qz.LogIt;
import qz.PrintApplet;
import qz.exception.InvalidFileTypeException;
import qz.exception.NullCommandException;
import qz.exception.NullPrintServiceException;

public class PrintRaw {
    private static final String ERR = "qz.PrintRaw.print() failed.";
    private final AtomicReference<DocFlavor> docFlavor = new AtomicReference<DocFlavor.BYTE_ARRAY>(DocFlavor.BYTE_ARRAY.AUTOSENSE);
    private final AtomicReference<DocAttributeSet> docAttr = new AtomicReference<Object>(null);
    private final AtomicReference<PrintRequestAttributeSet> reqAttr = new AtomicReference<HashPrintRequestAttributeSet>(new HashPrintRequestAttributeSet());
    private final AtomicReference<PrintService> ps = new AtomicReference<Object>(null);
    private final AtomicReference<ByteArrayBuilder> rawCmds = new AtomicReference<Object>(null);
    private final AtomicBoolean isFinished = new AtomicBoolean(false);
    private final AtomicReference<Charset> charset = new AtomicReference<Charset>(Charset.defaultCharset());
    private final AtomicReference<String> jobName = new AtomicReference<String>("QZ-PRINT Raw Printing");
    private final AtomicReference<String> outputPath = new AtomicReference<Object>(null);
    private final AtomicReference<String> socketHost = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> socketPort = new AtomicReference<Object>(null);
    private final AtomicBoolean alternatePrint = new AtomicBoolean(false);

    public PrintRaw() {
    }

    public PrintRaw(PrintService ps, String printString) throws UnsupportedEncodingException {
        this.ps.set(ps);
        this.rawCmds.set(new ByteArrayBuilder(printString.getBytes(this.charset.get().name())));
    }

    public PrintRaw(PrintService ps, String printString, DocFlavor docFlavor, DocAttributeSet docAttr, PrintRequestAttributeSet reqAttr, Charset charset) throws UnsupportedEncodingException {
        this.ps.set(ps);
        this.rawCmds.set(new ByteArrayBuilder(printString.getBytes(charset.name())));
        this.docFlavor.set(docFlavor);
        this.docAttr.set(docAttr);
        this.reqAttr.set(reqAttr);
        this.charset.set(charset);
    }

    public PrintRaw(PrintService ps, String printString, Charset charset, boolean alternatePrint) throws UnsupportedEncodingException {
        this.ps.set(ps);
        this.rawCmds.set(new ByteArrayBuilder(printString.getBytes(charset.name())));
        this.charset.set(charset);
        this.alternatePrint.set(alternatePrint);
    }

    public ByteArrayBuilder getRawCmds() {
        if (this.rawCmds.get() == null) {
            this.rawCmds.set(new ByteArrayBuilder());
        }
        return this.rawCmds.get();
    }

    public byte[] getByteArray() {
        return this.getRawCmds().getByteArray();
    }

    public void setOutputPath(String outputPath) throws InvalidFileTypeException {
        if (FileUtilities.isBadExtension(outputPath)) {
            throw new InvalidFileTypeException("Writing file \"" + outputPath + "\" is prohibited for security reason: " + "Prohibited file extension.");
        }
        this.outputPath.set(outputPath);
    }

    public void setOutputSocket(String host, int port) {
        this.socketHost.set(host);
        this.socketPort.set(port);
    }

    private boolean printToSocket() throws UnknownHostException, IOException {
        LogIt.log("Printing to host " + this.socketHost.get() + ":" + this.socketPort.get());
        Socket socket = new Socket(this.socketHost.get(), (int)this.socketPort.get());
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        out.write(this.getRawCmds().getByteArray());
        socket.close();
        return true;
    }

    public boolean printToFile() throws PrintException, IOException {
        LogIt.log("Printing to file: " + this.outputPath.get());
        FileOutputStream out = new FileOutputStream(this.outputPath.get());
        ((OutputStream)out).write(this.getRawCmds().getByteArray());
        ((OutputStream)out).close();
        return true;
    }

    public boolean print() throws IOException, InterruptedException, PrintException, UnsupportedEncodingException {
        return this.print(null);
    }

    public boolean print(byte[] data) throws IOException, PrintException, InterruptedException, UnsupportedEncodingException {
        if (this.ps.get() == null) {
            throw new NullPrintServiceException(ERR);
        }
        if (this.rawCmds.get() == null) {
            throw new NullCommandException(ERR);
        }
        if (this.outputPath.get() != null) {
            return this.printToFile();
        }
        if (this.socketHost.get() != null) {
            return this.printToSocket();
        }
        if (this.alternatePrint.get()) {
            return this.alternatePrint();
        }
        SimpleDoc doc = data != null ? new SimpleDoc(data, this.docFlavor.get(), this.docAttr.get()) : new SimpleDoc(this.getRawCmds().getByteArray(), this.docFlavor.get(), this.docAttr.get());
        this.reqAttr.get().add(new JobName(this.jobName.get(), Locale.getDefault()));
        DocPrintJob pj = this.ps.get().createPrintJob();
        pj.addPrintJobListener(new PrintJobListener(){

            public void printDataTransferCompleted(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobCompleted(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobFailed(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobCanceled(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobNoMoreEvents(PrintJobEvent pje) {
                LogIt.log(pje);
                PrintRaw.this.isFinished.set(true);
            }

            public void printJobRequiresAttention(PrintJobEvent pje) {
                LogIt.log(pje);
            }
        });
        LogIt.log("Sending print job to printer: \"" + this.ps.get().getName() + "\"");
        pj.print(doc, this.reqAttr.get());
        while (!this.isFinished.get()) {
            Thread.sleep(100L);
        }
        LogIt.log("Print job received by printer: \"" + this.ps.get().getName() + "\"");
        return true;
    }

    public boolean alternatePrint() throws PrintException {
        File tmpFile = new File("/tmp/qz-spool-" + System.currentTimeMillis());
        try {
            this.outputPath.set(tmpFile.getAbsolutePath());
            if (this.printToFile()) {
                String shellCmd = "/usr/bin/lp -d \"" + this.ps.get().getName() + "\" -o raw \"" + tmpFile.getAbsolutePath() + "\";";
                LogIt.log("Runtime Exec running: " + shellCmd);
                Process pr = Runtime.getRuntime().exec(new String[]{"bash", "-c", shellCmd});
                pr.waitFor();
                this.processStream(pr);
            }
        }
        catch (Throwable t) {
            throw new PrintException(t.getLocalizedMessage());
        }
        finally {
            tmpFile.delete();
            this.outputPath.set(null);
        }
        return true;
    }

    private void processStream(Process pr) throws Throwable {
        String tmp;
        BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        String output = "";
        while ((tmp = buf.readLine()) != null) {
            if (output.length() == 0) {
                output = tmp;
                continue;
            }
            output = output.concat("\n" + tmp);
        }
        LogIt.log("Runtime Exec returned: " + output);
        if (pr.exitValue() != 0) {
            throw new PrintException("Alternate printing returned a non-zero value (" + pr.exitValue() + "). " + output);
        }
    }

    public static boolean print(PrintService ps, String rawCmds) throws IOException, PrintException, InterruptedException, UnsupportedEncodingException {
        PrintRaw p = new PrintRaw(ps, rawCmds);
        return p.print();
    }

    public DocAttributeSet getDocAttributeSet() {
        return this.docAttr.get();
    }

    public void setDocAttributeSet(DocAttributeSet docAttr) {
        this.docAttr.set(docAttr);
    }

    public DocFlavor getDocFlavor() {
        return this.docFlavor.get();
    }

    public void setDocFlavor(DocFlavor docFlavor) {
        this.docFlavor.set(docFlavor);
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.reqAttr.get();
    }

    public void setPrintRequestAttributeSet(PrintRequestAttributeSet reqAttr) {
        this.reqAttr.set(reqAttr);
    }

    public PrintService getPrintService() {
        return this.ps.get();
    }

    public void setPrintService(PrintService ps) {
        this.ps.set(ps);
    }

    public String getOutput() {
        try {
            return new String(this.getRawCmds().getByteArray(), this.charset.get().name());
        }
        catch (Exception e) {
            LogIt.log(Level.WARNING, "Could not decode byte array into String for display. This may be normal for mixed or uncommon charsets.", e);
            return null;
        }
    }

    public void clear() {
        this.getRawCmds().clear();
        LogIt.log(Level.INFO, "Print buffer has been cleared.");
    }

    public void append(String s) throws UnsupportedEncodingException {
        this.getRawCmds().append(s, this.charset.get());
    }

    public void append(byte[] b) {
        this.getRawCmds().append(b);
    }

    public void setCharset(Charset charset) {
        this.charset.set(charset);
        LogIt.log("Current printer charset encoding: " + charset.name());
    }

    public Charset getCharset() {
        return this.charset.get();
    }

    public boolean isClear() {
        return this.getRawCmds().getLength() == 0;
    }

    public void setJobName(String jobName) {
        this.jobName.set(jobName);
    }

    public void setAlternatePrinting(boolean alternatePrint) {
        this.alternatePrint.set(alternatePrint);
    }

    public void setCopies(int copies) {
        LogIt.log(Level.WARNING, "Copies is unsupported for print()", new UnsupportedOperationException("Copies attribute for raw data has not yet been implemented"));
    }

    public int getCopies() {
        LogIt.log(Level.WARNING, "Copies is unsupported for print()", new UnsupportedOperationException("Copies attribute for raw data has not yet been implemented"));
        return -1;
    }

    public String getJobName() {
        return this.jobName.get();
    }

    public void setPrintParameters(PrintApplet rpa) {
        this.setPrintService(rpa.getPrintService());
        this.setJobName(rpa.getJobName().replace(" ___ ", " Raw "));
        this.setCharset(rpa.getCharset());
        this.setAlternatePrinting(rpa.isAlternatePrinting());
        if (rpa.getCopies() > 0) {
            this.setCopies(rpa.getCopies());
        }
        this.clear();
    }

    public boolean contains(String s) throws UnsupportedEncodingException {
        return this.contains(s.getBytes(this.charset.get().name()));
    }

    public boolean contains(byte[] bytes) {
        return ByteUtilities.indicesOfSublist(this.getByteArray(), bytes).length > 0;
    }
}

